import re
import ast
import json
from utils.util import is_json

class Protocol:
    def __init__(self, id="", title="", description="", steps="", category="", pseudocode="", publish_time="", program="", pseudofunctions="", dsl_program="", multi_dsl_program="") -> None:
        self.id = id
        self.title = title
        self.description = description
        self.steps = steps
        self.category = category
        self.pseudocode = pseudocode
        self.publish_time = publish_time
        self.program = program
        self.pseudofunctions = pseudofunctions
        self.dsl_program = dsl_program
        self.multi_dsl_program = multi_dsl_program
    
    @classmethod
    def fromjson(cls, data: dict):
        def process_bioprot_pseudocode(tot_pseudo):
            if not tot_pseudo:
                return None, None
            pseudofunctions = re.split(r"# Protocol (steps|Steps|execution)", tot_pseudo)[0].strip()
            pseudocode = re.split(r"# Protocol (steps|Steps|execution)", tot_pseudo)[-1].strip()
            pseudocode_lines = pseudocode.split('\n')
            filtered_pseudocode_lines = [line for line in pseudocode_lines if not line.strip().startswith('# end of protocol')]
            pseudocode_cleaned = '\n'.join(filtered_pseudocode_lines)
            return pseudofunctions, pseudocode_cleaned
        
        pseudofunctions, pseudocode_cleaned = process_bioprot_pseudocode(data.get("generated_pseudocode", ""))
        
        return cls(
            id=data.get("id", ""), 
            title=data.get("title", ""), 
            description=data.get("ai_generated_description", "") or data.get("description", ""),
            steps=data.get("steps", ""),
            category=data.get("category", ""), 
            pseudocode=pseudocode_cleaned or data.get("pseudocode", ""),
            pseudofunctions=pseudofunctions or data.get("pseudofunctions", ""),
            publish_time=data.get("publish_time", ""),
            program=data.get("program", ""),
            dsl_program=data.get("dsl_program", ""),
            multi_dsl_program=data.get("multi_dsl_program", "")
        )
    
    def tojson(self, *args) -> dict:
        '''
        "id": self.id,
        "title": self.title,
        "description": self.description,
        "steps": self.steps,
        "category": self.category,
        "publish_time": self.publish_time,
        "program": self.pseudocode
        '''
        metadata = {
            "id": self.id,
            "title": self.title,
            "description": self.description,
            "steps": self.steps,
            "category": self.category,
            "publish_time": self.publish_time,
            "pseudofunctions": self.pseudofunctions,
            "pseudocode": self.pseudocode,
            "program": self.program
        }
        if not args:
            return metadata
        filtered_metadata = {key: metadata[key] for key in args if key in metadata}
        return filtered_metadata
    
    def __repr__(self):
        # ANSI escape codes for styling
        bold_red = '\033[1;31m'
        end_style = '\033[0m'
        
        return (
            f"{bold_red}Id:{end_style} {self.id}\n"
            f"{bold_red}Title:{end_style} {self.title}\n"
            f"{bold_red}Description:{end_style} {self.description}\n"
            f"{bold_red}Steps:\n{end_style} {self.steps}\n"
            f"{bold_red}Category:{end_style} {self.category}\n"
            f"{bold_red}Publish Time:{end_style} {self.publish_time}\n"
            f"{bold_red}Pseudocode:\n{end_style} {self.pseudocode}\n"
        )
    
    def __str__(self) -> str:
        # ANSI escape codes for styling
        bold_red = '\033[1;31m'
        end_style = '\033[0m'
        
        return (
            f"{bold_red}Id:{end_style} {self.id}\n"
            f"{bold_red}Title:{end_style} {self.title}\n"
            f"{bold_red}Description:{end_style} {self.description}\n"
        )
    
    def __bool__(self):
        return all([self.title.strip(), self.description.strip()])
    
    def __lt__(self, other):
        return self.id < other.id
    
    def __eq__(self, other):
        self.id == other.id